#ifndef _TIMER_H_
#define _TIMER_H_

#include "ht32.h"

#define	BFTM_MIEN	(1UL << 0)
#define	BFTM_OSM		(1UL << 1)
#define	BFTM_CEN		(1UL << 2)
#define	BFTM_MIF		(1UL << 0)

typedef union 
{
   u8 value;
	struct 
   {
	   u8 t1ms : 1;
	   u8 t10ms : 1;
	   const u8 : 5;
		u8 tc_finish : 1;
	} bits;
} timer_operate_t;

extern timer_operate_t timer_operate;

void SystickConfigure(void);
void timer_counter_us(unsigned long n);
void delay_xxus(unsigned long unit,unsigned long n);
/*****************************************************************************************************
* @brief  delay n*ms
* @retval None
*******************************************************************************************************/
#define	delay_ms(n)			delay_xxus(1000,n)
/*****************************************************************************************************
* @brief  delay n*100us
* @retval None
*******************************************************************************************************/
#define	delay_100us(n)		delay_xxus(100,n)
/*****************************************************************************************************
* @brief  delay n*10us
* @retval None
*******************************************************************************************************/
#define	delay_10us(n)		delay_xxus(10,n)
/*****************************************************************************************************
* @brief  delay n*us
* @retval None
*******************************************************************************************************/
#define	delay_us(n)			delay_xxus(1,n)

#endif /* _TIMER_H_ */
